/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.IModelElementVisitor;
import com.aptana.editor.php.core.model.IParent;
import com.aptana.editor.php.core.model.ISourceModel;
import com.aptana.editor.php.core.model.ISourceProject;
import com.aptana.editor.php.core.model.env.ModelElementInfo;
import com.aptana.editor.php.internal.model.ModelManager;

public abstract class AbstractModelElement
implements IModelElement {
    public IModelElement getAncestor(int ancestorType) {
        IModelElement element = this.getParent();
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public ISourceProject getSourceProject() {
        return (ISourceProject)this.getAncestor(2);
    }

    public void accept(IModelElementVisitor visitor) {
        boolean result = visitor.visit((IModelElement)this);
        if (result && this instanceof IParent) {
            for (IModelElement child : ((IParent)this).getChildren()) {
                child.accept(visitor);
            }
        }
    }

    public ISourceModel getModel() {
        return ModelManager.getInstance().getModel();
    }

    public ModelElementInfo getElementInfo() {
        return null;
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        this.fillStringInfo(0, builder, true);
        return builder.toString();
    }

    protected void fillStringInfo(int tabsCount, StringBuilder builder, boolean showResolvedInfo) {
        builder.append(this.getStringTabs(tabsCount));
        this.toStringName(builder);
    }

    protected void toStringName(StringBuilder builder) {
        builder.append(this.getElementName());
    }

    protected String getStringTabs(int count) {
        StringBuilder builder = new StringBuilder();
        int i = count;
        while (i > 0) {
            builder.append("  ");
            --i;
        }
        return builder.toString();
    }

    public String toStringIncludingAncestors() {
        return this.toStringIncludingAncestors(true);
    }

    public String toStringIncludingAncestors(boolean includeResolvedInfo) {
        StringBuilder builder = new StringBuilder();
        this.fillStringInfo(0, builder, includeResolvedInfo);
        this.fillStringAncestors(builder);
        return builder.toString();
    }

    protected void fillStringAncestors(StringBuilder builder) {
        AbstractModelElement parentElement = (AbstractModelElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            builder.append(" [ in ");
            parentElement.fillStringInfo(0, builder, false);
            parentElement.fillStringAncestors(builder);
            builder.append(" ]");
        }
    }
}

